//+------------------------------------------------------------------+
//|                                                   C_Controls.mqh |
//|                                                      Daniel Jose |
//|                                                                  |
//+------------------------------------------------------------------+
#property copyright "Daniel Jose"
//+------------------------------------------------------------------+
#include <Market Replay\Interprocess.mqh>
//+------------------------------------------------------------------+
#define def_ButtonPlay 	"Images\\Market Replay\\Play.bmp"
#define def_ButtonPause	"Images\\Market Replay\\Pause.bmp"
#define def_ButtonLeft	"Images\\Market Replay\\Left.bmp"
#define def_ButtonRight "Images\\Market Replay\\Right.bmp"
#define def_ButtonPin	"Images\\Market Replay\\Pin.bmp"
#resource "\\" + def_ButtonPlay
#resource "\\" + def_ButtonPause
#resource "\\" + def_ButtonLeft
#resource "\\" + def_ButtonRight
#resource "\\" + def_ButtonPin
//+------------------------------------------------------------------+
#define def_PrefixObjectName 	"Market Replay _ "
#define def_NameObjectsSlider	def_PrefixObjectName + "Slider"
//+------------------------------------------------------------------+
#define def_MinPosXPin		100
//+------------------------------------------------------------------+
class C_Controls
{
	private	:
//+------------------------------------------------------------------+
		string	m_szBtnPlay;
		long		m_id;
		struct st_00
		{
			string 	szBtnLeft,
						szBtnRight,
						szBtnPin,
						szBarSlider;
			int		posPinSlider,
						posY;
		}m_Slider;
//+------------------------------------------------------------------+
inline void CreateObjectBitMap(int x, int y, string szName, string Resource1, string Resource2 = NULL)
			{
				ObjectCreate(m_id, szName, OBJ_BITMAP_LABEL, 0, 0, 0);
				ObjectSetInteger(m_id, szName, OBJPROP_XDISTANCE, x);
				ObjectSetInteger(m_id, szName, OBJPROP_YDISTANCE, y);
				ObjectSetString(m_id, szName, OBJPROP_BMPFILE, 0, "::" + Resource1);
				ObjectSetString(m_id, szName, OBJPROP_BMPFILE, 1, "::" + (Resource2 == NULL ? Resource1 : Resource2));
			}
//+------------------------------------------------------------------+
inline void CreteBarSlider(int x, int size)
			{
				ObjectCreate(m_id, m_Slider.szBarSlider, OBJ_RECTANGLE_LABEL, 0, 0, 0);
				ObjectSetInteger(m_id, m_Slider.szBarSlider, OBJPROP_XDISTANCE, x);
				ObjectSetInteger(m_id, m_Slider.szBarSlider, OBJPROP_YDISTANCE, m_Slider.posY - 4);
				ObjectSetInteger(m_id, m_Slider.szBarSlider, OBJPROP_XSIZE, size);
				ObjectSetInteger(m_id, m_Slider.szBarSlider, OBJPROP_YSIZE, 9);
				ObjectSetInteger(m_id, m_Slider.szBarSlider, OBJPROP_BGCOLOR, clrLightSkyBlue);
				ObjectSetInteger(m_id, m_Slider.szBarSlider, OBJPROP_BORDER_COLOR, clrBlack);
				ObjectSetInteger(m_id, m_Slider.szBarSlider, OBJPROP_WIDTH, 3);
				ObjectSetInteger(m_id, m_Slider.szBarSlider, OBJPROP_BORDER_TYPE, BORDER_FLAT);
			}
//+------------------------------------------------------------------+
		void CreateBtnPlayPause(bool state)
			{
				m_szBtnPlay = def_PrefixObjectName + "Play";
				CreateObjectBitMap(5, 25, m_szBtnPlay, def_ButtonPause, def_ButtonPlay);
				ObjectSetInteger(m_id, m_szBtnPlay, OBJPROP_STATE, state);
			}
//+------------------------------------------------------------------+
		void CreteCtrlSlider(void)
			{
				u_Interprocess Info;
				
				m_Slider.szBarSlider = def_NameObjectsSlider + " Bar";
				m_Slider.szBtnLeft	= def_NameObjectsSlider + " BtnL";
				m_Slider.szBtnRight	= def_NameObjectsSlider + " BtnR";
				m_Slider.szBtnPin		= def_NameObjectsSlider + " BtnP";
				m_Slider.posY = 40;
				CreteBarSlider(82, 436);
				CreateObjectBitMap(52, 25, m_Slider.szBtnLeft, def_ButtonLeft);
				CreateObjectBitMap(516, 25, m_Slider.szBtnRight, def_ButtonRight);
				CreateObjectBitMap(def_MinPosXPin, m_Slider.posY, m_Slider.szBtnPin, def_ButtonPin);
				ObjectSetInteger(m_id, m_Slider.szBtnPin, OBJPROP_ANCHOR, ANCHOR_CENTER);
				if (GlobalVariableCheck(def_GlobalVariableReplay)) Info.Value = GlobalVariableGet(def_GlobalVariableReplay); else Info.Value = 0;
				PositionPinSlider(Info.s_Infos.iPosShift);
			}
//+------------------------------------------------------------------+
inline void RemoveCtrlSlider(void)
			{			
				ChartSetInteger(m_id, CHART_EVENT_OBJECT_DELETE, false);
				ObjectsDeleteAll(m_id, def_NameObjectsSlider);
				ChartSetInteger(m_id, CHART_EVENT_OBJECT_DELETE, true);
			}
//+------------------------------------------------------------------+
inline void PositionPinSlider(int p)
			{
				m_Slider.posPinSlider = (p < 0 ? 0 : (p > def_MaxPosSlider ? def_MaxPosSlider : p));
				ObjectSetInteger(m_id, m_Slider.szBtnPin, OBJPROP_XDISTANCE, m_Slider.posPinSlider + def_MinPosXPin);
				ChartRedraw();
			}
//+------------------------------------------------------------------+
	public	:
//+------------------------------------------------------------------+
		C_Controls() : m_id(0)
			{
				m_szBtnPlay 			= NULL;
				m_Slider.szBarSlider = NULL;
				m_Slider.szBtnPin 	= NULL;
				m_Slider.szBtnLeft 	= NULL;
				m_Slider.szBtnRight 	= NULL;
			}
//+------------------------------------------------------------------+
		~C_Controls()
			{
				m_id = (m_id > 0 ? m_id : ChartID());
				ChartSetInteger(m_id, CHART_EVENT_OBJECT_DELETE, false);
				ObjectsDeleteAll(m_id, def_PrefixObjectName);
			}
//+------------------------------------------------------------------+
		void Init(const bool state = false)
			{
				u_Interprocess Info;
				
				if (m_szBtnPlay != NULL) return;
				m_id = ChartID();
				ChartSetInteger(m_id, CHART_EVENT_MOUSE_MOVE, true);
				ChartSetInteger(m_id, CHART_EVENT_OBJECT_DELETE, true);
				CreateBtnPlayPause(state);
				GlobalVariableTemp(def_GlobalVariableReplay);
				if (!state) CreteCtrlSlider();
				ChartRedraw();
				Info.Value = GlobalVariableGet(def_GlobalVariableReplay);
				Info.s_Infos.IsUsing = true;
				GlobalVariableSet(def_GlobalVariableReplay, Info.Value);
			}
//+------------------------------------------------------------------+
		void DispatchMessage(const int id, const long &lparam, const double &dparam, const string &sparam)
			{
				u_Interprocess Info;
				static int six = -1, sps;
				int x, y, px1, px2;
				
				switch (id)
				{
					case CHARTEVENT_OBJECT_DELETE:
						if (StringSubstr(sparam, 0, StringLen(def_PrefixObjectName)) == def_PrefixObjectName)
						{
							if (StringSubstr(sparam, 0, StringLen(def_NameObjectsSlider)) == def_NameObjectsSlider)
							{
								RemoveCtrlSlider();
								CreteCtrlSlider();
							}else
							{
								Info.Value = GlobalVariableGet(def_GlobalVariableReplay);
								CreateBtnPlayPause(Info.s_Infos.isPlay);
							}
							ChartRedraw();
						}
						break;
					case CHARTEVENT_OBJECT_CLICK:
						if (sparam == m_szBtnPlay)
						{
							Info.s_Infos.isPlay = (bool) ObjectGetInteger(m_id, m_szBtnPlay, OBJPROP_STATE);
							if (!Info.s_Infos.isPlay) CreteCtrlSlider(); else
							{
								RemoveCtrlSlider();
								m_Slider.szBtnPin = NULL;
							}
							Info.s_Infos.IsUsing = true;
							Info.s_Infos.iPosShift = m_Slider.posPinSlider;
							GlobalVariableSet(def_GlobalVariableReplay, Info.Value);
							ChartRedraw();
						}else	if (sparam == m_Slider.szBtnLeft) PositionPinSlider(m_Slider.posPinSlider - 1);
						else if (sparam == m_Slider.szBtnRight) PositionPinSlider(m_Slider.posPinSlider + 1);
						break;
					case CHARTEVENT_MOUSE_MOVE:
						x = (int)lparam;
						y = (int)dparam;
						px1 = m_Slider.posPinSlider + def_MinPosXPin - 14;
						px2 = m_Slider.posPinSlider + def_MinPosXPin + 14;
						if ((((uint)sparam & 0x01) == 1) && (m_Slider.szBtnPin != NULL))
						{
							if ((y >= (m_Slider.posY - 14)) && (y <= (m_Slider.posY + 14)) && (x >= px1) && (x <= px2) && (six == -1))
							{
								six = x;
								sps = m_Slider.posPinSlider;
								ChartSetInteger(m_id, CHART_MOUSE_SCROLL, false);
							}
							if (six > 0) PositionPinSlider(sps + x - six);
						}else if (six > 0)
						{
							six = -1;
							ChartSetInteger(m_id, CHART_MOUSE_SCROLL, true);
						}
						break;
				}
			}
//+------------------------------------------------------------------+
};
//+------------------------------------------------------------------+
#undef def_ButtonPlay
#undef def_ButtonPause
#undef def_ButtonLeft
#undef def_ButtonRight
#undef def_ButtonPin
#undef def_NameObjectsSlider
#undef def_PrefixObjectName
//+------------------------------------------------------------------+
